﻿/*
VERSION:	1.4

1.4		Added "mapTileSize" parameter

DECRIPTION:
	This system is meant to be used with the  tileWalk.as  style of movement.
	It collides with tiles on the map.

AVAILABLE DATA:
	This returns a collision function which changes its parent's objects & properties.
	The parent collision system (this) contains:
		xOffset, yOffset
		player_mc
			_x, _y
		collision_array
		walk_obj
			xVel, yVel
	
*/
function makeTileCollision( walk_obj, wallValues, mapTileSize )
{
	var tileSize = mapTileSize || MAP.tileSize || 16;
	walk_obj.wallValues = wallValues;
	var collision_funct = function()
	{
		if(this.walk_obj.wallValues==undefined)
			this.walk_obj.wallValues = [1];
		// extract velocities
		var xVel = this.walk_obj.xVel;
		var yVel = this.walk_obj.yVel;
		
		// get player's current tile
		var xPlayer = Math.floor(this.player_mc._x / tileSize);
		var yPlayer = Math.floor(this.player_mc._y / tileSize);
		
		// get destination tile
		var xDest = xPlayer + xVel;
		var yDest = yPlayer + yVel;
		
		// store collision value
		var collision = this.collision_array[xDest][yDest];
		
		// if collision value is not 0
		var isColliding = false;
		for(var nam in this.walk_obj.wallValues)
			if(collision==this.walk_obj.wallValues[nam])
				isColliding = true;
		if(collision==undefined)
			isColliding = true;
		if( isColliding )
		{
			// cancel all velocities
			this.walk_obj.xVel = 0;
			this.walk_obj.yVel = 0;
		}// if:  collision is imminent
	}// collision_funct()
	
	return collision_funct;
}// makeTileCollision()
